using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI dialog allowing users to select an item of equipment from inventory for association
		///</summary>

		#endregion


	public class DlgSelectEquipment : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		/// <summary>
		/// Items selected from the equipment listview
		/// </summary>
		private System.Collections.Hashtable _selectedItems = new System.Collections.Hashtable();
		
		/// <summary>
		/// List of available equipment -- unfiltered, returned from database
		/// </summary>
		private System.Collections.ArrayList _equipList;

		/// <summary>
		/// When a serach repopulates the grid, we don't want the onItemcheck events to fire
		/// </summary>
		private bool _isSearching = false;

		private BOL.BloodUnitModification _bumControl = null;

		#endregion

		#region FormControls

		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpResults;
		private System.Windows.Forms.ListView lvEquipment;
		private System.Windows.Forms.ColumnHeader colSerialNumber;
		private System.Windows.Forms.ColumnHeader colEquipmentName;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.ColumnHeader colEquipmentSelected;
		private System.Windows.Forms.ColumnHeader colManufacturer;
		private System.Windows.Forms.Panel pnlEquipmentType;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlManufacturer;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.Panel pnlSerialNumber;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbEquipmentType;
		private System.Windows.Forms.Label lblEquipmentType;
		private System.Windows.Forms.Label lblManufacturerSearchString;
		private System.Windows.Forms.TextBox txtSerialSearchString;
		private System.Windows.Forms.Label lblSerialSearchString;
		private System.Windows.Forms.Panel pnlSearchCriteria;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturer;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.ColumnHeader colEquipmentType;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Destructors

		/// <summary>
		/// Constructor that will populate form and select existing entries
		/// </summary>
		/// <param name="existingEquipmentList"></param>
		/// <param name="bumControl"></param>
		public DlgSelectEquipment(System.Collections.ArrayList existingEquipmentList, BOL.BloodUnitModification bumControl)
		{
			InitializeComponent();
			SetComponentProperties();
			//
			this._bumControl = bumControl;
			//
			if (this._bumControl.IsPool)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgSelectEquipment());
			}
			else if (this._bumControl.IsSplit)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgSelectEquipment());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgSelectEquipment());
			}
			//add our previously "selected" equipment to the hash table
			for(int ndx=0; ndx < existingEquipmentList.Count; ndx++)
			{
				BOL.Equipment tmpEquip = (BOL.Equipment)existingEquipmentList[ndx];
				this._selectedItems.Add(tmpEquip.EquipmentGuid, tmpEquip);
			}

			this.GetEquipment();
			this.PopulateComboBoxes();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectEquipment));
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.pnlSearchCriteria = new System.Windows.Forms.Panel();
			this.pnlSerialNumber = new System.Windows.Forms.Panel();
			this.btnClear = new System.Windows.Forms.Button();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtSerialSearchString = new System.Windows.Forms.TextBox();
			this.lblSerialSearchString = new System.Windows.Forms.Label();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.pnlManufacturer = new System.Windows.Forms.Panel();
			this.cmbManufacturer = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblManufacturerSearchString = new System.Windows.Forms.Label();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlEquipmentType = new System.Windows.Forms.Panel();
			this.cmbEquipmentType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblEquipmentType = new System.Windows.Forms.Label();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpResults = new System.Windows.Forms.GroupBox();
			this.lvEquipment = new System.Windows.Forms.ListView();
			this.colEquipmentSelected = new System.Windows.Forms.ColumnHeader();
			this.colSerialNumber = new System.Windows.Forms.ColumnHeader();
			this.colEquipmentName = new System.Windows.Forms.ColumnHeader();
			this.colEquipmentType = new System.Windows.Forms.ColumnHeader();
			this.colManufacturer = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.grpSearch.SuspendLayout();
			this.pnlSearchCriteria.SuspendLayout();
			this.pnlSerialNumber.SuspendLayout();
			this.pnlManufacturer.SuspendLayout();
			this.pnlEquipmentType.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpResults.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(712, 30);
			this.vbecsLogo1.TabIndex = 4;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpSearch
			// 
			this.grpSearch.AccessibleDescription = "Search Criteria";
			this.grpSearch.AccessibleName = "Search Criteria";
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.pnlSearchCriteria);
			this.grpSearch.Location = new System.Drawing.Point(56, 36);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(652, 60);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Search Criteria*";
			// 
			// pnlSearchCriteria
			// 
			this.pnlSearchCriteria.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSearchCriteria.Controls.Add(this.pnlSerialNumber);
			this.pnlSearchCriteria.Controls.Add(this.splitter2);
			this.pnlSearchCriteria.Controls.Add(this.pnlManufacturer);
			this.pnlSearchCriteria.Controls.Add(this.splitter1);
			this.pnlSearchCriteria.Controls.Add(this.pnlEquipmentType);
			this.pnlSearchCriteria.Location = new System.Drawing.Point(8, 12);
			this.pnlSearchCriteria.Name = "pnlSearchCriteria";
			this.pnlSearchCriteria.Size = new System.Drawing.Size(640, 44);
			this.pnlSearchCriteria.TabIndex = 37;
			this.pnlSearchCriteria.Resize += new System.EventHandler(this.pnlSearchCriteria_Resize);
			// 
			// pnlSerialNumber
			// 
			this.pnlSerialNumber.Controls.Add(this.btnClear);
			this.pnlSerialNumber.Controls.Add(this.btnSearch);
			this.pnlSerialNumber.Controls.Add(this.txtSerialSearchString);
			this.pnlSerialNumber.Controls.Add(this.lblSerialSearchString);
			this.pnlSerialNumber.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlSerialNumber.Location = new System.Drawing.Point(326, 0);
			this.pnlSerialNumber.Name = "pnlSerialNumber";
			this.pnlSerialNumber.Size = new System.Drawing.Size(314, 44);
			this.pnlSerialNumber.TabIndex = 4;
			// 
			// btnClear
			// 
			this.btnClear.Location = new System.Drawing.Point(232, 16);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 3;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// btnSearch
			// 
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = null;
			this.btnSearch.Location = new System.Drawing.Point(152, 16);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 2;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtSerialSearchString
			// 
			this.txtSerialSearchString.AccessibleDescription = "Serial Number";
			this.txtSerialSearchString.AccessibleName = "Serial Number";
			this.txtSerialSearchString.Location = new System.Drawing.Point(0, 22);
			this.txtSerialSearchString.MaxLength = 50;
			this.txtSerialSearchString.Name = "txtSerialSearchString";
			this.txtSerialSearchString.Size = new System.Drawing.Size(144, 20);
			this.txtSerialSearchString.TabIndex = 1;
			this.txtSerialSearchString.Text = "";
			// 
			// lblSerialSearchString
			// 
			this.lblSerialSearchString.Location = new System.Drawing.Point(0, 4);
			this.lblSerialSearchString.Name = "lblSerialSearchString";
			this.lblSerialSearchString.Size = new System.Drawing.Size(120, 20);
			this.lblSerialSearchString.TabIndex = 0;
			this.lblSerialSearchString.Text = "Serial Number";
			this.lblSerialSearchString.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter2
			// 
			this.splitter2.Location = new System.Drawing.Point(323, 0);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(3, 44);
			this.splitter2.TabIndex = 3;
			this.splitter2.TabStop = false;
			// 
			// pnlManufacturer
			// 
			this.pnlManufacturer.Controls.Add(this.cmbManufacturer);
			this.pnlManufacturer.Controls.Add(this.lblManufacturerSearchString);
			this.pnlManufacturer.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlManufacturer.Location = new System.Drawing.Point(163, 0);
			this.pnlManufacturer.Name = "pnlManufacturer";
			this.pnlManufacturer.Size = new System.Drawing.Size(160, 44);
			this.pnlManufacturer.TabIndex = 2;
			// 
			// cmbManufacturer
			// 
			this.cmbManufacturer.AccessibleDescription = "Manufacturer";
			this.cmbManufacturer.AccessibleName = "Manufacturer";
			this.cmbManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbManufacturer.Interval = 1000;
			this.cmbManufacturer.Location = new System.Drawing.Point(0, 20);
			this.cmbManufacturer.Name = "cmbManufacturer";
			this.cmbManufacturer.Size = new System.Drawing.Size(156, 22);
			this.cmbManufacturer.TabIndex = 1;
			// 
			// lblManufacturerSearchString
			// 
			this.lblManufacturerSearchString.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblManufacturerSearchString.Location = new System.Drawing.Point(0, 4);
			this.lblManufacturerSearchString.Name = "lblManufacturerSearchString";
			this.lblManufacturerSearchString.Size = new System.Drawing.Size(112, 20);
			this.lblManufacturerSearchString.TabIndex = 0;
			this.lblManufacturerSearchString.Text = "Manufacturer";
			this.lblManufacturerSearchString.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(160, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 44);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlEquipmentType
			// 
			this.pnlEquipmentType.Controls.Add(this.cmbEquipmentType);
			this.pnlEquipmentType.Controls.Add(this.lblEquipmentType);
			this.pnlEquipmentType.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlEquipmentType.Location = new System.Drawing.Point(0, 0);
			this.pnlEquipmentType.Name = "pnlEquipmentType";
			this.pnlEquipmentType.Size = new System.Drawing.Size(160, 44);
			this.pnlEquipmentType.TabIndex = 0;
			// 
			// cmbEquipmentType
			// 
			this.cmbEquipmentType.AccessibleDescription = "Equipment Type";
			this.cmbEquipmentType.AccessibleName = "Equipment Type";
			this.cmbEquipmentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbEquipmentType.Interval = 1000;
			this.cmbEquipmentType.Location = new System.Drawing.Point(0, 20);
			this.cmbEquipmentType.Name = "cmbEquipmentType";
			this.cmbEquipmentType.Size = new System.Drawing.Size(156, 22);
			this.cmbEquipmentType.TabIndex = 1;
			// 
			// lblEquipmentType
			// 
			this.lblEquipmentType.Location = new System.Drawing.Point(0, 4);
			this.lblEquipmentType.Name = "lblEquipmentType";
			this.lblEquipmentType.Size = new System.Drawing.Size(88, 20);
			this.lblEquipmentType.TabIndex = 0;
			this.lblEquipmentType.Text = "Equipment Type";
			this.lblEquipmentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(48, 308);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(40, 40);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// grpResults
			// 
			this.grpResults.AccessibleDescription = "Search Results";
			this.grpResults.AccessibleName = "Search Results";
			this.grpResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpResults.Controls.Add(this.lvEquipment);
			this.grpResults.Location = new System.Drawing.Point(56, 100);
			this.grpResults.Name = "grpResults";
			this.grpResults.Size = new System.Drawing.Size(652, 244);
			this.grpResults.TabIndex = 1;
			this.grpResults.TabStop = false;
			this.grpResults.Text = "Search Results";
			// 
			// lvEquipment
			// 
			this.lvEquipment.AccessibleDescription = "Equipment Information";
			this.lvEquipment.AccessibleName = "Equipment Information";
			this.lvEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvEquipment.CheckBoxes = true;
			this.lvEquipment.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colEquipmentSelected,
																						  this.colSerialNumber,
																						  this.colEquipmentName,
																						  this.colEquipmentType,
																						  this.colManufacturer});
			this.lvEquipment.FullRowSelect = true;
			this.lvEquipment.Location = new System.Drawing.Point(8, 16);
			this.lvEquipment.MultiSelect = false;
			this.lvEquipment.Name = "lvEquipment";
			this.lvEquipment.Size = new System.Drawing.Size(638, 220);
			this.lvEquipment.TabIndex = 0;
			this.lvEquipment.View = System.Windows.Forms.View.Details;
			this.lvEquipment.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvEquipment_ColumnClick);
			this.lvEquipment.SelectedIndexChanged += new System.EventHandler(this.lvEquipment_SelectedIndexChanged);
			this.lvEquipment.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvEquipment_ItemCheck);
			// 
			// colEquipmentSelected
			// 
			this.colEquipmentSelected.Text = "";
			this.colEquipmentSelected.Width = 25;
			// 
			// colSerialNumber
			// 
			this.colSerialNumber.Text = "Serial Number";
			this.colSerialNumber.Width = 80;
			// 
			// colEquipmentName
			// 
			this.colEquipmentName.Text = "Equipment Name";
			this.colEquipmentName.Width = 120;
			// 
			// colEquipmentType
			// 
			this.colEquipmentType.Text = "Equipment Type";
			this.colEquipmentType.Width = 120;
			// 
			// colManufacturer
			// 
			this.colManufacturer.Text = "Manufacturer";
			this.colManufacturer.Width = 130;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(628, 348);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(548, 348);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// DlgSelectEquipment
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(712, 373);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpSearch);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpResults);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(720, 400);
			this.Name = "DlgSelectEquipment";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Equipment";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectEquipment_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpResults, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpSearch, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.grpSearch.ResumeLayout(false);
			this.pnlSearchCriteria.ResumeLayout(false);
			this.pnlSerialNumber.ResumeLayout(false);
			this.pnlManufacturer.ResumeLayout(false);
			this.pnlEquipmentType.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpResults.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Gets ArrayList of selected equipment items
		/// </summary>
		public System.Collections.ArrayList SelectedEquipmentList
		{
			get
			{
				System.Collections.ArrayList equipList = new System.Collections.ArrayList();

				foreach(ListViewItem lvi in this.lvEquipment.CheckedItems)
				{
					BOL.Equipment equip = (BOL.Equipment)lvi.Tag;
					equipList.Add(equip);
				}

				return(equipList);
			}
		}

		#endregion

		#region Methods/Functions

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Select Equipment";
			
			this.cmbEquipmentType.Interval = 100;
			this.cmbManufacturer.Interval = 100;

			this.btnSearch.Text = "&Search";
			this.btnSearch.SetToolTip(Common.StrRes.Tooltips.Common.SearchFor().ResString);
			this.ttToolTip.SetToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearEntries().ResString);

			this.lvEquipment.MultiSelect = true;

			//Equipment isn't required, so they can hit enter at any time
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
		}

		/// <summary>
		/// Fills the combox boxes with values retrieved from the database
		/// </summary>
		private void PopulateComboBoxes()
		{
			System.Collections.ArrayList equipInfo = BOL.Equipment.GetEquipmentDetails();
			System.Collections.ArrayList equipTypes = (System.Collections.ArrayList)equipInfo[0];
			System.Collections.ArrayList manufacturers = (System.Collections.ArrayList)equipInfo[1];

			//Load the SupplyTypes
			this.cmbEquipmentType.Items.Clear();
			for(int ndx=0; ndx < equipTypes.Count; ndx++)
			{
				this.cmbEquipmentType.Items.Add(equipTypes[ndx].ToString());
			}

			//Load the manufacturers
			this.cmbManufacturer.Items.Clear();
			for(int ndx=0; ndx < manufacturers.Count; ndx++)
			{
				this.cmbManufacturer.Items.Add(manufacturers[ndx].ToString());
			}

		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/9/2004</CreationDate>
		///
		/// <summary>
		/// Private method to load equipment items into UI for selection
		/// </summary>
		/// <param name="equipmentList">ArrayList of equipment GUIDS</param>
		private void LoadEquipment(System.Collections.ArrayList equipmentList)
		{
			bool checkItem = false;

			this.lvEquipment.Items.Clear();

			for(int ndx=0; ndx < equipmentList.Count; ndx++)
			{
				BOL.Equipment equip = (BOL.Equipment)equipmentList[ndx];

				checkItem = this._selectedItems.Contains(equip.EquipmentGuid);
				this.AddEquipmentToListview(equip, checkItem);
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvEquipment);
		}

		/// <summary>
		/// Adds a equipment row to the lvEquipment control
		/// </summary>
		/// <param name="equipObj"></param>
		/// <param name="checkItem"></param>
		private void AddEquipmentToListview(BOL.Equipment equipObj, bool checkItem)
		{
			ListViewItem lvi = new ListViewItem();

			lvi.Checked = checkItem;				
			lvi.Tag = equipObj;

			lvi.SubItems.Add(equipObj.SerialNumber);
			lvi.SubItems.Add(equipObj.EquipmentName);
			lvi.SubItems.Add(equipObj.EquipmentType);
			lvi.SubItems.Add(equipObj.ManufacturerName);
				
			this.lvEquipment.Items.Add(lvi);            
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to get list of matching equipment from database and display in UI
		/// </summary>
		private void GetEquipment()
		{
			this._equipList = BOL.Equipment.GetEquipmentList();
			this.LoadEquipment(this._equipList);
		}


		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Search criteria panel resize event handler, aligns UI controls evenly
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void pnlSearchCriteria_Resize(object sender, System.EventArgs e)
		{
			this.pnlEquipmentType.Width = (int)((this.pnlSearchCriteria.Width -6)/3);
			this.pnlManufacturer.Width = (int)((this.pnlSearchCriteria.Width -6)/3);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, closes dialog with OK result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// Sorts the listview data based on column click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvEquipment_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvEquipment.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}


		/// <summary>
		/// Resets the search criteria combo boxes and textbox
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			//Reset the seach criteria
			this.cmbEquipmentType.SelectedIndex = -1;
			this.cmbEquipmentType.Text = string.Empty;
			this.cmbManufacturer.SelectedIndex = -1;
			this.cmbManufacturer.Text = string.Empty;
			this.txtSerialSearchString.Text = string.Empty;
		}


		/// <summary>
		/// Filters the list of equipment using serach criteria
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this._isSearching = true;

			bool noResultsFound = true;

			//Get a new list of equpiment -- for real-time like behavior!
			this._equipList = BOL.Equipment.GetEquipmentList();

			//Clear the listview out first
			this.lvEquipment.Items.Clear();

			System.Collections.Hashtable newResultSet = new System.Collections.Hashtable();

			IDictionaryEnumerator iter1 = this._selectedItems.GetEnumerator();
			while (iter1.MoveNext())
			{
				BOL.Equipment tmpEquipment = (BOL.Equipment)iter1.Value;
				AddEquipmentToListview(tmpEquipment, true);
			}

			for(int ndx=0; ndx < this._equipList.Count; ndx++)
			{
				bool manCheck = true;
				bool typeCheck = true;
				bool serialCheck = true;
				bool alreadyExists = false;
				BOL.Equipment objTest = (BOL.Equipment)this._equipList[ndx];

				//If they entered a manufacturer, check it
				if (this.cmbManufacturer.Text != string.Empty)
				{
					if (objTest.ManufacturerName != this.cmbManufacturer.Text)
						manCheck = false;
				}

				//If they entered a supply type, check it
				if (this.cmbEquipmentType.Text != string.Empty)
				{
					if (objTest.EquipmentType != this.cmbEquipmentType.Text)
						typeCheck = false;
				}
				
				//If they've enetered a lotnumber to search on, check it
				if (this.txtSerialSearchString.Text.Length > 0)
				{
					if (objTest.SerialNumber != this.txtSerialSearchString.Text)
						serialCheck = false;
				}

				//If the items already been selected, we don't want to re-add it to the grid
				if (this._selectedItems.Contains(objTest.EquipmentGuid))
					alreadyExists = true;


				if (manCheck && typeCheck && serialCheck && !alreadyExists)
				{
					this.AddEquipmentToListview(objTest, false);
					noResultsFound = false;
				}
			}

			this._isSearching = false;

			if (noResultsFound)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC020.NoMatchingEntries());
			}

		}


		/// <summary>
		/// Checks/Unchecks a equipment row
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvEquipment_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (!this._isSearching)
			{
				BOL.Equipment tmpEquip = (BOL.Equipment)this.lvEquipment.Items[e.Index].Tag;

				if (e.NewValue == CheckState.Checked)
				{
					if (!this._selectedItems.ContainsKey(tmpEquip.EquipmentGuid))
						this._selectedItems.Add(tmpEquip.EquipmentGuid, tmpEquip);
				}
				else
				{
					if (this._selectedItems.ContainsKey(tmpEquip.EquipmentGuid))
						this._selectedItems.Remove(tmpEquip.EquipmentGuid);
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectEquipment_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion

		private void lvEquipment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvEquipment);
		}
	}
}

